/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class QCanvas
extends Canvas
implements CommandListener,
Runnable {
    public static Graphics GC;
    public static int IMAGE_WIDTH;
    public static int IMAGE_HEIGHT;
    public static int HIGHSCORE;
    private int ACT_GAME_NUM;
    private final int MAX_GAME_NUM;
    private final int MILLIS_PER_TICK;
    private final Font GAME_FONT = Font.getFont((int)0, (int)0, (int)8);
    private final Font TEXT_FONT = Font.getFont((int)0, (int)0, (int)8);
    private final Command backCommand = new Command(QRes.getText("back"), 2, 0);
    private volatile Thread animation = null;
    private QSprites sprites;
    private boolean keyHit;
    private String l1;
    private String l2;
    private String l3;
    private boolean bShowScore = false;
    private boolean hold = false;
    public static long TT;
    private static long T0;

    QCanvas() {
        this.MAX_GAME_NUM = 5;
        this.MILLIS_PER_TICK = 40;
        IMAGE_WIDTH = this.getWidth();
        IMAGE_HEIGHT = this.getHeight();
        this.sprites = new QSprites();
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        long l = 0L;
        long l2 = 0L;
        try {
            while (thread == this.animation) {
                l = System.currentTimeMillis();
                if (this.isShown()) {
                    this.tick();
                    this.repaint();
                }
                if ((l2 = System.currentTimeMillis() - l) < 40L) {
                    QCanvas qCanvas = this;
                    synchronized (qCanvas) {
                        this.wait(40L - l2);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.stop();
            QMain.setNextAction(2);
        }
    }

    protected void keyPressed(int n) {
        if (this.hold) {
            this.hold = false;
            return;
        }
        if (this.bShowScore) {
            this.bShowScore = false;
            return;
        }
        if (this.keyHit) {
            return;
        }
        if (QSprites.sState == 3) {
            QSprites.sHitPoint = System.currentTimeMillis() - SYeti.dt0;
            QSprites.sActYetiDrawn1 = QSprites.sActYetiDrawn;
            if (QSprites.sActYetiDrawn1 >= 6) {
                if (QSprites.sHitPoint < 5000L) {
                    if (QSprites.sHitPoint > -1L) {
                        this.keyHit = true;
                    }
                }
            }
        } else {
            this.keyHit = true;
        }
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2;
        GC = graphics;
        GC.setFont(this.GAME_FONT);
        GC.setColor(0);
        this.sprites.draw();
        GC.setColor(0);
        GC.drawString("" + HIGHSCORE / 10 + "." + HIGHSCORE % 10, 0, 176 - this.GAME_FONT.getHeight(), 36);
        if (this.bShowScore) {
            n2 = this.GAME_FONT.stringWidth(this.l3);
            if (n2 < this.GAME_FONT.stringWidth(this.l1)) {
                n2 = this.GAME_FONT.stringWidth(this.l1);
            }
            n = this.GAME_FONT.getHeight() * 3 + 9 + 4;
            int n3 = (IMAGE_WIDTH - (n2 += 4)) / 2;
            int n4 = (IMAGE_HEIGHT - n) / 2;
            GC.setColor(0);
            GC.fillRect(n3, n4, n2, n);
            GC.setColor(0xFF0000);
            GC.drawRect(n3, n4, n2, n);
            GC.drawString(this.l1, IMAGE_WIDTH / 2, n4 + 2, 17);
            GC.drawString(this.l2, IMAGE_WIDTH / 2, 2 + n4 + n / 3, 17);
            GC.drawString(this.l3, IMAGE_WIDTH / 2, 4 + n4 + n / 3 * 2, 17);
        }
        if (this.hold) {
            n2 = this.GAME_FONT.stringWidth(QRes.getText("menu_continue")) + 4;
            n = this.GAME_FONT.getHeight() + 4;
            GC.setColor(0xFFFFFF);
            GC.fillRect((IMAGE_WIDTH - n2) / 2, (IMAGE_HEIGHT - n) / 2, n2, n);
            GC.setColor(255);
            GC.drawRect((IMAGE_WIDTH - n2) / 2, (IMAGE_HEIGHT - n) / 2, n2, n);
            GC.drawString(QRes.getText("menu_continue"), IMAGE_WIDTH / 2, (IMAGE_HEIGHT - n) / 2 + 2, 17);
        }
        GC.setFont(this.TEXT_FONT);
        GC.setColor(0);
        GC.drawString("" + (this.ACT_GAME_NUM + 1) + " / " + 5, 2, 2, 20);
    }

    public synchronized void start() {
        this.animation = new Thread(this);
        this.animation.start();
    }

    public synchronized void stop() {
        this.animation = null;
    }

    public synchronized void pause(boolean bl) {
        this.hold = bl;
    }

    public void init() {
        this.ACT_GAME_NUM = 0;
        HIGHSCORE = 0;
        this.keyHit = false;
        this.sprites.init();
    }

    public void continueGame() {
    }

    private void tick() {
        if (this.hold) {
            return;
        }
        if (this.bShowScore) {
            return;
        }
        if (QSprites.sState == 10) {
            this.keyHit = false;
            ++this.ACT_GAME_NUM;
            HIGHSCORE += QSprites.sScore;
            if (this.ACT_GAME_NUM < 5) {
                this.sprites.init();
            } else {
                QScore.setScore(QMain.sNick, HIGHSCORE, 1);
                this.enableShowScore(HIGHSCORE);
                this.init();
                QMain.setNextAction(4);
            }
        } else if (this.keyHit) {
            this.keyHit = false;
            this.sprites.hit();
        }
        this.sprites.tick();
    }

    private void enableShowScore(int n) {
        this.bShowScore = true;
        this.l3 = QRes.getText("hs_continue");
        this.l2 = " " + n / 10 + "." + n % 10 + " ";
        this.l1 = QRes.getText("dsp_score_norm");
        if (n == QScore.getScore(0)) {
            this.l1 = QRes.getText("dsp_score_top");
            return;
        }
        for (int i = 1; i < 5; ++i) {
            if (n != QScore.getScore(i)) continue;
            this.l1 = QRes.getText("dsp_score_high");
            return;
        }
    }

    static {
        TT = 0L;
        T0 = 0L;
    }
}

